//Caption: Program to find impulse response and
//Frequency Response of a system
//y[n] = a*y[n-1]+x[n]
//Assume y[n] = h[n], x[n]=delta[n]=unit impulse response
//a = 0.9
//h[n] = 0.9*h[n-1]+delta[n]
clc;
clear;
close;
a = 0.9;//constant a = 0.9 less than 1
h0 = 1;
h1 = a; //first two values of impulse response
h = [h0,h1,zeros(1,100)];
for i = 1:100
  h(i+2) = ((a)^(i+1))*h(i+1);//impulse response
end
[HW,W] = frmag(h,512); //frequency response
figure(1)
subplot(2,1,1)
a = gca();
a.x_location = 'origin';
a.y_location = 'origin';
plot([1:length(h)],h,'r');
xlabel('Discrete Time Index n---->');
ylabel('Impulse Response h[n]----->');
title('Impulse Response of first order recursive system')
xgrid(1)
subplot(2,1,2)
a = gca();
a.x_location = 'origin';
a.y_location = 'origin';
plot([mtlb_fliplr(-2*%pi*W),2*%pi*W(2:$)],[mtlb_fliplr(abs(HW)),abs(HW(2:$))])
xlabel('Discrete Frequency index W------>')
ylabel('Magnitude Response |H(W)|------>')
title('Frequency Response of a causal, stable, LTI Ist Order Recursive System');
xgrid(1)